import asyncio
import socket
import os
import fnmatch

from pylog.pylogger import PyLogger

from datetime import datetime

from py_pli.pylib import VUnits

from predefined_tasks.common.helper import send_to_gc, report_path, write_header_to_report

from virtualunits.vu_measurement_unit import VUMeasurementUnit
from virtualunits.meas_seq_generator import meas_seq_generator
from virtualunits.meas_seq_generator import TriggerSignal
from virtualunits.meas_seq_generator import OutputSignal

from fleming.common.firmware_util import get_fan_control_endpoint
from fleming.common.firmware_util import get_node_endpoint
from fleming.common.firmware_util import get_serial_endpoint


from urpc_enum.measurementparameter import MeasurementParameter

from fleming.common.firmware_util import EEFAnalogInput


# Data Aquisition 

def get_datafile(path, base_name, test_function):
    instrument = socket.gethostname()
    today = datetime.now().strftime('%Y%m%d')
    datapath = f'{path}/{instrument}_{today}'
    if not os.path.isdir(datapath):
        os.mkdir(datapath)
    datafile = f'{base_name}_{test_function}_Run'
    no = len(fnmatch.filter(os.listdir(datapath), datafile + '*.csv')) + 1
    datafile = f'{datafile}{no:03d}.csv'
    return(f'{datapath}/{datafile}')

# Helper Functions

def create_function_list(filename, prefix =""):
    # Creates a list with all functions of a Python-Script and writes it in a .fun File
    # preceeded by "prefix" as template for service_tasks.adj
    with open(filename, 'r') as file:
        tree = ast.parse(file.read(), filename=filename)

    function_names = [node.name for node in ast.walk(tree) if isinstance(node, ast.FunctionDef)]   
    list_name = filename.replace(".py", ".fun")

    with open(list_name, 'w') as file:
        for f in function_names:
            file.write(prefix + f + '\n')
    
    return(list_name)


# Usefull Snippets

# Bargraph at the console
bar = lambda x, x_max, width = 80, char = "|" : char.ljust(int(x / x_max * width), char)

## Board Function

# fmb = get_node_endpoint('fmb')

# eef = get_node_endpoint('eef')

## Moverfunctions



## Temperature-Sensor Functions

temp_elements = {
    'htu'   : 0, # Upper heating
    'htl'   : 1, # Lower heating
    'htb'   : 2, # Dispenser bottle heating
    'tec'   : 3, # 
    'av1'   : 15, # AVU Peltier Pin 1
    'av2'   : 16, # AVU Peltier Pin 2
    'pmt_1' : 9, # PMT 1 Peltier
    'pmt_2' : 10, # PMT 1 Peltier
}

async def get_tmp(tmb_name):
    # 2021-11-26/kstruebing
    # Conversion factor added
    """
    TMB: Readout of single TMB-Sensor
    tmb_name:
    tmb_upper: Upper Heating
    tmb_lower: Lower Heating
    tmb_in:    AVU internal Fan inlet 
    tmb_out:   AVU internal Fan outlet
    tmb_fl:    Flashlamp Temp
    tmb_int:   AVU Internal Fan (Cool side Peltier) 
    tmb_ext:   AVU external Fan (Hot side Peltier)
    tmb_am:    Ambient Temp
    tmb_hum:   Humidity Sensor
    tmb_p1:    PMT 1  
    tmb_p2:    PMT 2
    """
    if tmb_name not in temp_sensors:
        raise ValueError(f"{tmb_name} not valid.")
    
    node = get_node_endpoint(temp_sensors[tmb_name]['node'])
    value = (await node.GetAnalogInput(temp_sensors[tmb_name]['number']))[0] * int(temp_sensors[tmb_name]['conv'])
    return value


## Temperature-Element Functions

pwm_status = {
    'AV_otw'   : 11, # PWM 2 Driver (AV1+ 2) Overtemperature Warning
    'AV_fault' : 10, # PWM 2 Driver (AV1+ 2) Fault
    'HT_otw'   : 9, # PWM 1 Driver (HTL+ U) Overtemperature Warning
    'HT_fault' : 8, # PWM 1 Driver (HTL+ U) Fault
    'PMT_AL_otw'  : 25, # PWM driver PMT1-TEC, PMT2-TEC and Alpha Laser TEC overtemperature warning (active low)
    'PMT_AL_fault': 24 # PWM driver PMT1-TEC, PMT2-TEC and Alpha Laser TEC fault signal (active low)
}

temp_elements = {
    'htu'   : 0, # Upper heating
    'htl'   : 1, # Lower heating
    'htb'   : 2, # Dispenser bottle heating
    'tec'   : 3, # 
    'av1'   : 15, # AVU Peltier Pin 1
    'av2'   : 16, # AVU Peltier Pin 2
    'pmt_1' : 9, # PMT 1 Peltier
    'pmt_2' : 10, # PMT 1 Peltier
}


async def tec_on(pwm = 65, fan = 10):
    min_pwm = 0.05
    fmb = get_node_endpoint('fmb')
    await _fan_pwm('int', fan)
    await _fan_pwm('ext', 100)
    p_1 = temp_elements['av2']
    p_2 = temp_elements['av1']

    await fmb.SetAnalogOutput(p_1, (min_pwm))
    await fmb.SetAnalogOutput(p_2, (pwm / 100) + min_pwm)

    return('AVU TE switched on')

async def tec_off():
    fmb = get_node_endpoint('fmb')
    min_pwm = 0.05
    p_1 = temp_elements['av1']
    p_2 = temp_elements['av2']

    await fmb.SetAnalogOutput(p_1, min_pwm)
    await fmb.SetAnalogOutput(p_2, min_pwm)

    return('AVU TEC switched off.')


## Fan Control

async def fan_pwm(fan_name, pwr):
    # 2021-11-26/kstruebing
    # node added

    """
    fan_name: base1, base2, base3, int, ext, pc, fl, trf
    pwr: 0...100%
    """
    if (pwr < 0) or (pwr > 100):
        raise ValueError(f"pwr must be in the range [0, 100]")

    fan = get_fan_control_endpoint(fans[fan_name]['node'])
    channel = fans[fan_name]['channel']
    await fan.SetSpeed(channel, pwr, timeout=1)
    await fan.Enable(channel, (pwr > 0), timeout=1)
    return f"Fan '{fan_name}' @ {int(pwr)}%"


# Alpha Functions ######################################################################################################

async def al_enable():
    measurement_unit = VUnits.instance.hal.measurementUnit
    await measurement_unit.MeasurementFunctions.SetParameter(MeasurementParameter.AlphaLaserEnable, 1, timeout=1)
    await asyncio.sleep(0.1)


async def al_disable():
    measurement_unit = VUnits.instance.hal.measurementUnit
    await measurement_unit.MeasurementFunctions.SetParameter(MeasurementParameter.AlphaLaserEnable, 0, timeout=1)
    await asyncio.sleep(0.1)


async def al_setpower(power=3103):
    measurement_unit = VUnits.instance.hal.measurementUnit
    await measurement_unit.MeasurementFunctions.SetParameter(MeasurementParameter.AlphaLaserPower, (float(power) / 4096), timeout=1)
    await asyncio.sleep(0.1)


async def al_settemp(tref=0.38):  # 0.33
    temp_control_unit = VUnits.instance.hal.AlphaLaserStandard_Cooling
    await temp_control_unit.set_target_temperature(tref)


async def al_gettemp():
    temp_control_unit = VUnits.instance.hal.AlphaLaserStandard_Cooling
    return (await temp_control_unit.get_feedback_value())[0]


async def al_getpd():
    eef = VUnits.instance.hal.nodes['eef'].node
    return (await eef.GetAnalogInput(EEFAnalogInput.ALPHAPHOTODIODE, timeout=1))[0]


async def al_on():
    measurement_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    op_id = 'al_on'
    seq_gen = meas_seq_generator()
    seq_gen.ResetSignals(OutputSignal.Alpha)    # Reset Signal to turn Laser On!!!!
    seq_gen.Stop(0)
    measurement_unit.ClearOperations()
    await measurement_unit.LoadTriggerSequence(op_id, seq_gen.currSequence)
    await measurement_unit.ExecuteMeasurement(op_id)
    PyLogger.logger.info('=============Alpha-Laser On!!!==================')


async def al_off():
    measurement_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    op_id = 'al_off'
    seq_gen = meas_seq_generator()
    seq_gen.SetSignals(OutputSignal.Alpha)    # Set Signal to turn Laser Off!!!
    seq_gen.Stop(0)
    measurement_unit.ClearOperations()
    await measurement_unit.LoadTriggerSequence(op_id, seq_gen.currSequence)
    await measurement_unit.ExecuteMeasurement(op_id)
    PyLogger.logger.info('=============Alpha-Laser Off!!!==================')


# PMT Functions ########################################################################################################

async def hvpmt1on():
    # Reset Signal to turn on!!!
    measurement_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    op_id = 'hvpmt1on'
    seq_gen = meas_seq_generator()
    seq_gen.ResetSignals(OutputSignal.HVOnPMT1)
    seq_gen.Stop(0)
    measurement_unit.ClearOperations()
    await measurement_unit.LoadTriggerSequence(op_id, seq_gen.currSequence)
    await measurement_unit.ExecuteMeasurement(op_id)
    PyLogger.logger.info('=============HV PMT1 On!!!==================')


async def hvpmt2on():
    # Reset Signal to turn on!!!
    measurement_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    op_id = 'hvpmt2on'
    seq_gen = meas_seq_generator()
    seq_gen.ResetSignals(OutputSignal.HVOnPMT2)
    seq_gen.Stop(0)
    measurement_unit.ClearOperations()
    await measurement_unit.LoadTriggerSequence(op_id, seq_gen.currSequence)
    await measurement_unit.ExecuteMeasurement(op_id)
    PyLogger.logger.info('=============HV PMT2 On!!!==================')


async def hvpmt1off():
    #Set Signal to turn off!!
    measurement_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    op_id = 'hvpmt1off'
    seq_gen = meas_seq_generator()
    seq_gen.SetSignals(OutputSignal.HVOnPMT1)
    seq_gen.Stop(0)
    measurement_unit.ClearOperations()
    await measurement_unit.LoadTriggerSequence(op_id, seq_gen.currSequence)
    await measurement_unit.ExecuteMeasurement(op_id)
    PyLogger.logger.info('=============HV PMT1 Off!!!==================')


async def hvpmt2off():
    #Set Signal to turn off!!
    measurement_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    op_id = 'hvpmt2off'
    seq_gen = meas_seq_generator()
    seq_gen.SetSignals(OutputSignal.HVOnPMT2)
    seq_gen.Stop(0)
    measurement_unit.ClearOperations()
    await measurement_unit.LoadTriggerSequence(op_id, seq_gen.currSequence)
    await measurement_unit.ExecuteMeasurement(op_id)
    PyLogger.logger.info('=============HV PMT2 Off!!!==================')


async def hvgate1on():
    measurement_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    op_id = 'hvgate1on'
    seq_gen = meas_seq_generator()
    seq_gen.SetSignals(OutputSignal.HVGatePMT1)
    seq_gen.Stop(0)
    measurement_unit.ClearOperations()
    await measurement_unit.LoadTriggerSequence(op_id, seq_gen.currSequence)
    await measurement_unit.ExecuteMeasurement(op_id)


async def hvgate2on():
    measurement_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    op_id = 'hvgate2on'
    seq_gen = meas_seq_generator()
    seq_gen.SetSignals(OutputSignal.HVGatePMT2)
    seq_gen.Stop(0)
    measurement_unit.ClearOperations()
    await measurement_unit.LoadTriggerSequence(op_id, seq_gen.currSequence)
    await measurement_unit.ExecuteMeasurement(op_id)


async def hvgate1off():
    measurement_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    op_id = 'hvgate1off'
    seq_gen = meas_seq_generator()
    seq_gen.ResetSignals(OutputSignal.HVGatePMT1)
    seq_gen.Stop(0)
    measurement_unit.ClearOperations()
    await measurement_unit.LoadTriggerSequence(op_id, seq_gen.currSequence)
    await measurement_unit.ExecuteMeasurement(op_id)


async def hvgate2off():
    measurement_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    op_id = 'hvgate2off'
    seq_gen = meas_seq_generator()
    seq_gen.ResetSignals(OutputSignal.HVGatePMT2)
    seq_gen.Stop(0)
    measurement_unit.ClearOperations()
    await measurement_unit.LoadTriggerSequence(op_id, seq_gen.currSequence)
    await measurement_unit.ExecuteMeasurement(op_id)

